//
//  Gradient.m
//  ABC Bank
//
//  Created by davesm on 10/21/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "Gradient.h"
#import <QuartzCore/QuartzCore.h>

@implementation Gradient

+ (UIImage *)gradientImageOfSize:(CGSize)size topColor:(UIColor *)topColor bottomColor:(UIColor *)bottomColor
{
    CAGradientLayer * gradientLayer = [CAGradientLayer layer];
    gradientLayer.frame = CGRectMake( 0, 0, size.width, size.height );
    gradientLayer.colors = [NSArray arrayWithObjects:
                            (id)topColor.CGColor,
                            (id)bottomColor.CGColor,
                            nil];
    
    UIGraphicsBeginImageContext(gradientLayer.bounds.size);
    [gradientLayer renderInContext:UIGraphicsGetCurrentContext()];
    UIImage * gradientImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return gradientImage;
}

+ (UIColor *)gradientColorOfSize:(CGSize)size topColor:(UIColor *)topColor bottomColor:(UIColor *)bottomColor
{
    UIImage * gradientImage = [self gradientImageOfSize:size
                                               topColor:topColor
                                            bottomColor:bottomColor];
    
    return [UIColor colorWithPatternImage:gradientImage];
}

+ (void)applyBackgroundGradient:(UIView *)view topColor:(UIColor *)topColor bottomColor:(UIColor *)bottomColor
{
    UIColor * gradientColor = [self gradientColorOfSize:CGSizeMake(1, view.bounds.size.height)
                                               topColor:topColor
                                            bottomColor:bottomColor];
    
    
    
    
    view.backgroundColor = gradientColor;
}

@end
